/* --------------------------------------------------------------
  comma_to_dot.js 2019-06-19
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

let numericRegularExpression = /^[0-9,.]+$/,
	commaRegularExpression = /,/g;

let addReplaceCommaToDotListener = function() {
		
		let $formInputs = $('form[name="product_edit"] input[type="text"]');
		
		$formInputs.each(function() {
			this.addEventListener('keyup', replaceCommaToDot);
		});
	},
	replaceCommaToDot = function() {
		
		let content = $(this).val();
		
		if (content.match(numericRegularExpression) !== null && content.match(commaRegularExpression) !== null) {
			
			content = content.replace(commaRegularExpression, '.');
			
			$(this).val(content);
		}
	};

if (document.readyState === "loading") {
	document.addEventListener('DOMContentLoaded', addReplaceCommaToDotListener);
} else {
	addReplaceCommaToDotListener();
}